function fetchData() {
  fetch("api/check_status.php")
    .then(res => res.text())
    .then(text => document.getElementById("status").textContent = text);

  fetch("api/server_info_public.php")
    .then(res => res.json())
    .then(data => {
      document.getElementById("servername").textContent = data.servername || "-";
      document.getElementById("serverid").textContent = data.server_id || "-";

      // Mods untereinander anzeigen
      const modsElem = document.getElementById("mods");
      modsElem.innerHTML = "";
      (data.mods || []).forEach(mod => {
        const div = document.createElement("div");
        div.style.display = "block";
        div.textContent = mod;
        modsElem.appendChild(div);
      });

      document.getElementById("spieler").textContent = data.players || "-";

      // Speichern verbundene Spieler (für Moderator-Filterung)
      window.currentOnlinePlayers = (data.online_players || []).map(name => name.toLowerCase());
    });

  fetch("api/player_stats_public.php")
    .then(res => res.json())
    .then(data => {
      const container = document.getElementById("spielerlist");
      container.innerHTML = "";
      if (Object.keys(data).length === 0) {
        container.textContent = "Keine Spieler online.";
        return;
      }
      for (const [name, info] of Object.entries(data)) {
        const div = document.createElement("div");
        div.textContent = `${name} - Online: ${info.online ? "Ja" : "Nein"}, Verbindungen: ${info.connections}, Zeit: ${formatSeconds(info.total_online)}`;
        container.appendChild(div);
      }
    });

  fetch("api/steam-id-api_to_name.php")
    .then(res => res.json())
    .then(data => {
      const container = document.getElementById("moderatoren");
      container.innerHTML = "";
      const mods = data.moderators || {};
      const onlinePlayers = window.currentOnlinePlayers || [];

      // Filtere nur Moderatoren, deren Name in onlinePlayers enthalten ist (case-insensitive)
      const onlineMods = Object.values(mods).filter(name =>
        onlinePlayers.includes(name.toLowerCase())
      );

      if (onlineMods.length === 0) {
        container.textContent = "Keine Moderatoren online.";
        return;
      }

      for (const name of onlineMods) {
        const div = document.createElement("div");
        div.textContent = name;
        container.appendChild(div);
      }
    });

  fetch("data/download_link.txt")
    .then(res => res.text())
    .then(link => {
      const a = document.getElementById("downloadlink");
      a.href = link;
    });
}

function formatSeconds(s) {
  const h = Math.floor(s / 3600);
  const m = Math.floor((s % 3600) / 60);
  const sec = s % 60;
  return `${h}h ${m}m ${sec}s`;
}

fetchData();
setInterval(fetchData, 10000);


// Admininfo laden
fetch('admin_info_public.php')
  .then(res => res.text())
  .then(data => document.getElementById('admininfo').innerHTML = data);
